package {
	
	import away3d.containers.View3D;
	import away3d.core.utils.Init;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.PixelSnapping;
	import flash.events.Event;
	import flash.media.Camera;
	import flash.media.Video;
	import flash.utils.ByteArray;
	import flash.utils.Timer;
	
	import net.saqoosha.util.DelayNotifier;
	
	import org.libspark.flartoolkit.away3d.FLARBaseNode;
	import org.libspark.flartoolkit.away3d.FLARCamera3D;
	import org.libspark.flartoolkit.core.FLARCode;
	import org.libspark.flartoolkit.core.param.FLARParam;
	import org.libspark.flartoolkit.core.raster.rgb.FLARRgbRaster_BitmapData;
	import org.libspark.flartoolkit.core.transmat.FLARTransMatResult;
	import org.libspark.flartoolkit.detector.FLARSingleMarkerDetector;

	public class AwayFLARView3D extends View3D {
		
		// input	
		private var _webcam:Camera;
		private var _video:Video;
		private var _capture:Bitmap;
		
		// ar
		private var _param:FLARParam;
		private var _code:FLARCode;
		private var _raster:FLARRgbRaster_BitmapData;
		private var _threshold:int;
		private var _detector:FLARSingleMarkerDetector;
		private var _resultMat:FLARTransMatResult;
		private var _detected:Boolean;
		private var _delayNotifier:DelayNotifier;
		
		// 3d
		private var _camera:FLARCamera3D;
		private var _baseNode:FLARBaseNode;
		
		public function AwayFLARView3D(init:Object=null) {
			super(init);
			var ini:Init = Init.parse(init) as Init;
			
			// input
			this._webcam = Camera.getCamera();
			if (!this._webcam) {
				throw new Error('No webcam!');
			}
			this._webcam.setMode(320, 240, 30);
			this._video = new Video(320, 240);
			this._video.attachCamera(this._webcam);
			this._capture = new Bitmap(new BitmapData(320, 240, false, 0), PixelSnapping.AUTO, true);
			this._capture.x = -160 + 2;
			this._capture.y = -120;
			this.background.addChild(this._capture);
			
			// ar
			this._param = new FLARParam();
			this._param.loadARParam(ini.getObject('param', ByteArray) as ByteArray);
			this._param.changeScreenSize(320, 240);
			this._code = new FLARCode(16, 16);
			this._code.loadARPatt(ini.getObject('code', ByteArray).toString());
			this._raster = new FLARRgbRaster_BitmapData(this._capture.bitmapData);
			this._threshold = ini.getInt('threshold', 80, {min:0, max:255});
			this._detector = new FLARSingleMarkerDetector(this._param, this._code, 80);
			this._detector.setContinueMode(ini.getBoolean('continueMode', false));
			this._resultMat = new FLARTransMatResult();
			this._detected = false;
			this._delayNotifier = new DelayNotifier(1000, false);
			this._delayNotifier.addEventListener(Event.CHANGE, this.dispatchEvent);
			
			// 3d
			this.camera = new FLARCamera3D(this._param);
			this._baseNode = new FLARBaseNode();
			this.scene.addChild(this._baseNode);
		}
		
		public function detect():Boolean {
			this._capture.bitmapData.draw(this._video);
			var detected:Boolean = false;
			if (this._detector.detectMarkerLite(this._raster, this._threshold) && this._detector.getConfidence() > 0.5) {
				this._detector.getTransformMatrix(this._resultMat);
				this._baseNode.setTransformMatrix(this._resultMat);
				detected = true;
			}
			this._delayNotifier.value = detected;
			return detected;
		}
		
		public function get threshold():int {
			return this._threshold;
		}
		
		public function set threshold(value:int):void {
			this._threshold = value;
		}
		
		public function get detected():Boolean { 
			return this._delayNotifier.value;
		}
		
		public function get marker():FLARBaseNode {
			return this._baseNode;
		}
		
		public function get captureImage():Bitmap {
			return this._capture;
		}
		
		public function get binaryImage():BitmapData {
			return this._detector.binaryImage;
		}
	}
}